import { estimatedTimeSpanRangeFormatter } from "@/lib/formatters/time-span-formatters";
import { TimeSpan } from "@/lib/time";
import { expect, test } from 'vitest'

test('creates time estimate string from record', () => {
    const testData = [
        {
            input: TimeSpan.fromMinutes(15),
            expected: '15 min - 45 min'
        },
        {
            input: TimeSpan.fromMinutes(29),
            expected: '30 min - 01 hr 15 min'
        },
        {
            input: TimeSpan.fromMinutes(40),
            expected: '45 min - 01 hr 45 min'
        },
        {
            input: TimeSpan.fromMinutes(60),
            expected: '01 hr - 02 hr'
        },
        {
            input: TimeSpan.fromMinutes(100),
            expected: '01 hr 45 min - 03 hr 15 min'
        },
        {
            input: TimeSpan.fromMinutes(155),
            expected: '02 hr 45 min - 04 hr 15 min'
        },
        {
            input: TimeSpan.fromMinutes(180),
            expected: '03 hr - 05 hr'
        },
    ] satisfies {
        input: TimeSpan,
        expected: string,
    }[]


    for (const d of testData) {
        const result = estimatedTimeSpanRangeFormatter(d.input);
        expect(result).toBe(d.expected)
    }
})
